/*************************************************************************
*    CompuCell - A software framework for multimodel simulations of     *
* biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
*                             Indiana                                   *
*                                                                       *
* This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
*  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
*  CompuCell GNU General Public License RIDER you can redistribute it   *
* and/or modify it under the terms of the GNU General Public License as *
*  published by the Free Software Foundation; either version 2 of the   *
*         License, or (at your option) any later version.               *
*                                                                       *
* This program is distributed in the hope that it will be useful, but   *
*      WITHOUT ANY WARRANTY; without even the implied warranty of       *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
*             General Public License for more details.                  *
*                                                                       *
*  You should have received a copy of the GNU General Public License    *
*     along with this program; if not, write to the Free Software       *
*      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
*************************************************************************/



#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>

using namespace CompuCell3D;



#include <math.h>
#include <iostream>
#include <string>
using namespace std;

#define EXP_STL
#include "ClusterDataTrackerPlugin.h"

ClusterDataTrackerPlugin::ClusterDataTrackerPlugin() :  potts(0), initialCellTargetVolume(0),initialTotalTargetVolume(0),clusterTargetVolume(0),clusterLambdaVolume(0),clusterIdFluid(0),fluidLambdaVolume(0), lumenFluidLambdaVolume(0) {
    xmlData=0; 
}

ClusterDataTrackerPlugin::~ClusterDataTrackerPlugin() {
}



void ClusterDataTrackerPlugin::init(Simulator *simulator, CC3DXMLElement *_xmlData)
{ cerr<<"CDT init"<<endl;
     xmlData=_xmlData;
	sim=simulator;
	potts = simulator->getPotts();
        potts->registerEnergyFunctionWithName(this,toString());
	potts->registerCellGChangeWatcher(this);
	potts->registerStepper(this);
    fieldG = (WatchableField3D<CellG *> *)potts->getCellFieldG();
    automaton = potts->getAutomaton();
   
    
    cerr<<"CDT init0"<<endl;
    cellInventoryPtr = & potts->getCellInventory();
         
    cerr<<"CDT init end"<<endl;
}

void ClusterDataTrackerPlugin::extraInit(Simulator *simulator)
{
    //if (fibrinFlipPenalty>0)
        //{
        Ffibrin= simulator->getConcentrationFieldByName("totalfibrin");   
        //FPLSfibrin= simulator->getConcentrationFieldByName("FPLS"); 
        //FPLGfibrin= simulator->getConcentrationFieldByName("FPLG");
       // }
  update(xmlData,true);  
   
}

void ClusterDataTrackerPlugin::update(CC3DXMLElement *_xmlData, bool _fullInitFlag)
{
       cerr<<"CDT update end"<<endl; 

    if(_xmlData->getFirstElement("InitialClusterLambdaVolume"))
     

            {
             cerr<<"CTD yes found !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"<<endl;
             clusterLambdaVolume=_xmlData->getFirstElement("InitialClusterLambdaVolume")->getDouble();
            }
    else{clusterLambdaVolume=0;}
     cerr<<"CDT update initialclusterlambdavolume="<<clusterLambdaVolume<<endl;
    //load clusterTargetVolume and clusterLambdaVolume from XML
     if(_xmlData->getFirstElement("InitialClusterTargetVolume"))
             clusterTargetVolume=_xmlData->getFirstElement("InitialClusterTargetVolume")->getDouble();

     if(_xmlData->getFirstElement("FluidLambdaVolume"))
            {
             fluidLambdaVolume=_xmlData->getFirstElement("FluidLambdaVolume")->getDouble();
            }
     if(_xmlData->getFirstElement("LumenFluidLambdaVolume"))
             lumenFluidLambdaVolume=_xmlData->getFirstElement("LumenFluidLambdaVolume")->getDouble();
     
     if(_xmlData->getFirstElement("fibrinFlipPenalty"))
         fibrinFlipPenalty=_xmlData->getFirstElement("fibrinFlipPenalty")->getDouble();
      else
          fibrinFlipPenalty=0.0;
    if(_xmlData->getFirstElement("probabilityMedium"))
         probabilityMedium=_xmlData->getFirstElement("probabilityMedium")->getDouble();
      else
          probabilityMedium=0.0;
      
           rand = BasicRandomNumberGenerator::getInstance();
}

std::string ClusterDataTrackerPlugin::toString(){return "ClusterDataTrackerPlugin";}

std::string ClusterDataTrackerPlugin::steerableName(){return toString();}


void ClusterDataTrackerPlugin::field3DChange(const Point3D &pt, CellG *newCell, CellG *oldCell) 
{
    
     //cerr<<"CDT start"<<endl;
    //load membranePolarizatonFluidSteppable
    bool alreadyRegisteredFlag;
    string n="MembranePolarizationFluidSteppable";
    MPS=(MembranePolarizationFluidSteppable *)Simulator::steppableManager.get
        (n,&alreadyRegisteredFlag);

    //bool deletePixel becomes active when a vacuole has no targetvolume and becomes deleted.
    bool deletePixel=false; 
    if (newCell && oldCell)
        {          
        //cerr<<"CTD newCell="<<newCell<<" type="<<(int) newCell->type<<" oldcell="<<oldCell<< " oldtype="<<(int) oldCell->type<<endl; 
        //if from same cluster        
        if (newCell->clusterId == oldCell->clusterId) 
            {
            //when vesicle created (newcell vol=1), goes to insertCellInCluster and gets cv upp there, thus decrease here
            if (newCell->volume==1) 
                {
                if ( clusterDataMap.find(newCell->clusterId) != clusterDataMap.end() )
                    (clusterDataMap.find(newCell->clusterId)->second).clusterVolume-=1;                
                }
                
             //if vacuole becomes one pixel in size, it becomes a vesicle. Also happens when vac of 2 pixels has one pixel turn into ves (newcell->type=0).            
            if ((oldCell->volume==1) && (oldCell->type==automaton->getTypeId("vacuole")))// && (newCell->type))  
                { 
 
                //if targetvolume is larger than one this is substracted from the cell clustervolume and added to fluid volume or an overtaking vacuole.               
                if (oldCell->targetVolume>1)
                    {
                    double substract=oldCell->targetVolume-1; 
                    oldCell->targetVolume-=substract;                   
                    if (newCell->type==automaton->getTypeId("vacuole"))
                        {                      
                        newCell->targetVolume+=substract;                  
                        }
                    else
                       {                 
                        addClusterTargetVolume(oldCell->clusterId, -substract);    
               //if no fluid or fluid conservement next for lines out            
// // //                         CellG* fluidCell=getFluidCell();
// // //                         if (fluidCell)
// // //                             {     
// // //                             addClusterTargetVolume(fluidCell->clusterId, substract);
// // //                             }
                        }                        
                    }

                //The pixel will be adjusted in the type, targetvolume and lambda of the vesicle.                
                oldCell->type=automaton->getTypeId("vesicle");       
                oldCell->targetVolume=oldCell->targetVolume;
                oldCell->lambdaVolume=MPS->vesicleLambdaVolume; 
                potts->runSteppers();                

                }  
            //If oldcell has no longer volume                
            if (!oldCell->volume)
                 {
                //a viscle or vacuole takes over a vesicle or vacuole, tv fused to newcell
                if (((newCell->type==automaton->getTypeId("vesicle"))||(newCell->type==automaton->getTypeId("vacuole")))&& ((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole"))))
                    {
                    newCell->targetVolume+=oldCell->targetVolume;
                    }
                //a vesicle or vacuole is taken over by cell, apical or basolat, fuse the tv of it to fluid               
                else if (((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole"))) && (newCell->type))
                    { 
                    (clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume-=oldCell->targetVolume;           
                  //only adjust fluid when in model      
// // //                     CellG* fluidCell=getFluidCell();
// // //                     if (fluidCell) 
// // //                         {  
// // //                         (clusterDataMap.find(fluidCell->clusterId)->second).clusterTargetVolume+=oldCell->targetVolume;      
// // //                         }                      
                    }  
                //now delete the oldcell from the clusterdata celllist.                
                if ( clusterDataMap.find(oldCell->clusterId) != clusterDataMap.end() )      
                    {        
                     deleteCellInCluster(oldCell);
                    }
                }
            }                

        //if they are from different clusters        
        if (newCell->clusterId != oldCell->clusterId)
            { 
             //adjust clustervolumes           
            if ( clusterDataMap.find(newCell->clusterId) != clusterDataMap.end() )
                (clusterDataMap.find(newCell->clusterId)->second).clusterVolume+=1;
            if ( clusterDataMap.find(oldCell->clusterId) != clusterDataMap.end() )
                (clusterDataMap.find(oldCell->clusterId)->second).clusterVolume-=1; 
            
            //when lumenpixel created (newcell vol=1), goes to insertCellInCluster and gets cv upp there, thus decrease here. Corrected for when lumenfluid or fluid made.
            if (newCell->volume==1) 
                {            
                if ( clusterDataMap.find(newCell->clusterId) != clusterDataMap.end() )
                    (clusterDataMap.find(newCell->clusterId)->second).clusterVolume-=1;                   
                }
                
            //correct for tv's                    
            if (oldCell->volume)
                {  
                //if lumenfluid takes over vesicle or vacuole, correct tv                    
                if (((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole")))&&(newCell->type && (newCell->type==automaton->getTypeId("lumenfluid"))))
                    {                         
                    if (oldCell->targetVolume>=1)
                        {                       
                        (clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume-=1; 
                        (clusterDataMap.find(newCell->clusterId)->second).clusterTargetVolume+=1; 
                        oldCell->targetVolume-=1;
                        }
                    }                    
                
                 //if vacuole becomes one pixel in size, it becomes a vesicle. Do not enter during secretion, if lumenfluid is made first time.             
                if ((oldCell->volume==1) && (oldCell->type==automaton->getTypeId("vacuole")))// && (newCell->type))  
                    { 
     
                    //if targetvolume is larger than one this is substracted from the cell clustervolume and added to fluid volume or an overtaking vacuole.               
                    if (oldCell->targetVolume>1)
                        {
                        double substract=oldCell->targetVolume-1; 
                        addClusterTargetVolume(oldCell->clusterId, -substract); 
                        oldCell->targetVolume-=substract;                   
                        if ((newCell->type) && (newCell->type==automaton->getTypeId("vacuole")))
                            {                      
                            newCell->targetVolume+=substract;  
                            addClusterTargetVolume(newCell->clusterId, substract);                
                            }
                        else if ((newCell->type) && (newCell->type==automaton->getTypeId("lumenfluid")))
                            {addClusterTargetVolume(newCell->clusterId, substract);}
                            //only adjust fluid if in model
// // //                         else
// // //                            {                                 
// // //                             CellG* fluidCell=getFluidCell();
// // //                             if (fluidCell)
// // //                                 {     
// // //                                 addClusterTargetVolume(fluidCell->clusterId, substract);
// // //                                 }
// // //                             }                        
                        }
    
                    //The pixel will be adjusted in the type, targetvolume and lambda of the vesicle.                
                    oldCell->type=automaton->getTypeId("vesicle");       
                    oldCell->targetVolume=oldCell->targetVolume;
                    oldCell->lambdaVolume=MPS->vesicleLambdaVolume; 
                    potts->runSteppers();                
    
                    }     
                }
            //if oldcell no volume, correct for tv   
            if (!oldCell->volume)
                {  
                //vesicle or vacuole is taken over by NOT lumenfluid, thus by other cell. Decrease CTV oldcell and increase CTV fluid                
                if (((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole")))&&(newCell->type && (newCell->type!=automaton->getTypeId("lumenfluid"))))
                    {                    
                    (clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume-=oldCell->targetVolume;        
                     //only adjust fluid if in model   
// // //                     CellG* fluidCell=getFluidCell();
// // //                     if (fluidCell)     
// // //                         (clusterDataMap.find(fluidCell->clusterId)->second).clusterTargetVolume+=oldCell->targetVolume;      
                    } 
                //vesicle or vacuole is taken over by lumenfluid. Decrease CTV oldcell and increase CTV lumenfluid                  
                else if (((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole")))&&(newCell->type && (newCell->type==automaton->getTypeId("lumenfluid"))))
                    { 
                    (clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume-=oldCell->targetVolume; 
                    (clusterDataMap.find(newCell->clusterId)->second).clusterTargetVolume+=oldCell->targetVolume; 
                    } 
                //lumenfluids take over each other, fuse CTV
                if ((newCell->type==automaton->getTypeId("lumenfluid")) && (oldCell->type==automaton->getTypeId("lumenfluid")))//hier voor hele cel targetvol ipv 1 ofzo 
                    {
                    (clusterDataMap.find(newCell->clusterId)->second).clusterTargetVolume+=(clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume;
                    (clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume-=(clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume;                  
                    } 
                   //only adjust fluid if in model 
// // //                 //lumenfluid taken over by NOT lumenfluid,  fuse CTV deleted lumenfluid to fluid               
// // //                 else if ((!(newCell->type==automaton->getTypeId("lumenfluid"))) && (oldCell->type==automaton->getTypeId("lumenfluid")))
// // //                     {              
// // //                     CellG* fluidCell=getFluidCell();
// // //                     if (fluidCell)    
// // //                         (clusterDataMap.find(fluidCell->clusterId)->second).clusterTargetVolume+=(clusterDataMap.find(oldCell->clusterId)->second).clusterTargetVolume;      
// // //                     }    
                //ceel has to be deleted from clusterdata cell list            
                if ( clusterDataMap.find(oldCell->clusterId) != clusterDataMap.end() )   
                    {           
                    deleteCellInCluster(oldCell);
                    }                    
                }           
            }
        } 
  
////if medium is in model   
      else if (!newCell && oldCell)
        {                
        if ( clusterDataMap.find(oldCell->clusterId) != clusterDataMap.end() )
            (clusterDataMap.find(oldCell->clusterId)->second).clusterVolume-=1;                
        if (!oldCell->volume)
            {
            if ( clusterDataMap.find(oldCell->clusterId) != clusterDataMap.end() )   
                {           
                deleteCellInCluster(oldCell);
                } 
            }
                
        }
      else if (newCell && !oldCell)
        {                
        if ( clusterDataMap.find(newCell->clusterId) != clusterDataMap.end() )
            (clusterDataMap.find(newCell->clusterId)->second).clusterVolume+=1;                
              
        }
     
   //cerr<<"CDT  end"<<endl;   
        
//     else if (!newCell && oldCell)
//         {

//         //cerr<<"we have medium newCell="<<newCell<<" oldcell="<<oldCell<< " oldtype="<<(int) oldCell->type<<" oldcell vol="<<oldCell->volume<<endl;
            
//     //For the medium Insertion model, when medium is created between cells we need to fuse it to fluid and adjust clusterVolumes
               
//         CellG* fluidCell=getFluidCell();
//         if (fluidCell) 
//             {          
//             fieldG->set(pt,fluidCell);             
//             } 
//         else{
//             //cerr<<"create to fluidcell"<<endl;
//             fluidCell=potts->createCellG(pt); //create fluidcell          
//             fluidCell->type=automaton->getTypeId("fluid"); //set type
//             insertCellInCluster(fluidCell);
//             //to adjust for things happening in field3Dchange by line 300
//             (clusterDataMap.find(fluidCell->clusterId)->second).clusterTargetVolume-=1;   //to compensate for tv in insert, we do not want to give it tv
//             (clusterDataMap.find(fluidCell->clusterId)->second).clusterVolume+=1; // to compensate for substraction when newcell has volume 1 implemnted for vesicles, since they were already of same cluster
//             //cerr<<"corrections fluid done"<<endl;
//             }          
          
//         field3DChange(pt, fluidCell, oldCell); //, now will go trhough CTD.cpp again, and adjust volumes for the actual transition 
//         potts->runSteppers();
//         } 


      
}

double ClusterDataTrackerPlugin::changeEnergy(const Point3D &pt,const CellG *newCell,const CellG *oldCell) 
{ 
     double energy=0.0;
    return energy;
}
void ClusterDataTrackerPlugin::step() { 
    
}

